<?php
/**
 * Customizer specific functions
 *
 * @package Goodz
 */

// List all categories in dropdown
function goodz_get_categories_select() {

    $teh_cats = get_categories();
    $results = array();

    $count = count( $teh_cats );
    $results['default'] = esc_html__( '-- Select --', 'goodz' );

    if ( !empty( $teh_cats ) ) {
        for ( $i=0; $i < $count; $i++ ) {
            if ( isset( $teh_cats[$i] ) )
                $results[$teh_cats[$i]->slug] = $teh_cats[$i]->name;
            else
                $count++;
        }
        return $results;
    }

}

// Get All Pages and create select box for Customizer
function goodz_get_page_select(){

    $pages = get_pages();

    if ( ! empty ( $pages ) ) {
        $results['default'] = esc_html__( '-- Select --', 'goodz' );

        foreach ( $pages as $page ) {
            $results[$page->ID] = $page->post_title;
        }
        return $results;
    }

}

// List all product categories in dropdown
function goodz_get_product_categories_select() {

    if ( taxonomy_exists( 'product_cat' ) ) {

        $teh_cats = get_terms( 'product_cat' );
        $results  = array();

        $count = count( $teh_cats );

        if ( !empty( $teh_cats ) ) {
            foreach ( $teh_cats as $teh_cat ) {
                $results[$teh_cat->slug] = $teh_cat->name;
            }
            return $results;
        }

    }

}

// List all product categories in dropdown
function goodz_get_front_product_categories_select() {

    if ( taxonomy_exists( 'product_cat' ) ) {

        $teh_cats = get_terms( 'product_cat' );
        $results = array();

        $count = count( $teh_cats );
        $results['default'] = esc_html__( 'Top selling', 'goodz' );
        $results['newest']  = esc_html__( 'Newest', 'goodz' );

        if ( !empty( $teh_cats ) ) {
            for ( $i=0; $i < $count; $i++ ) {
                if ( isset( $teh_cats[$i] ) )
                    $results[$teh_cats[$i]->term_id] = $teh_cats[$i]->name;
                else
                    $count++;
            }
            return $results;
        }

    }

}

// List all product categories in dropdown
function goodz_get_brand_categories_select() {

    $results            = array();
    $results['default'] = esc_html__( '-- All --', 'goodz' );

    if ( taxonomy_exists( 'ct_brands' ) ) {

        $teh_cats = get_terms( 'ct_brands' );

        $count = count( $teh_cats );

        if ( !empty( $teh_cats ) ) {
            for ( $i=0; $i < $count; $i++ ) {
                if ( isset( $teh_cats[$i] ) )
                    $results[$teh_cats[$i]->slug] = $teh_cats[$i]->name;
                else
                    $count++;
            }

        }

    }

    return $results;

}

// List all categories in dropdown
function goodz_get_slider_categories_select() {

    if ( taxonomy_exists( 'ct_slider' ) ) {
        $teh_cats           = get_terms( 'ct_slider' );
        $results            = array();
        $count              = count( $teh_cats );
        $results['default'] = esc_html__( '-- Select --', 'goodz' );

        if ( !empty( $teh_cats ) ) {
            foreach ( $teh_cats as $teh_cat ) {
                $results[$teh_cat->slug] = $teh_cat->name;
            }
            return $results;
        }
    }

}

// List 1 - 10
function goodz_number_of_slides() {

    $results = array();

    for ( $i=1; $i <= 10; $i++ ) {
        $results[ $i ] = $i;
    }

    return $results;

}

/**
 * Populate select box for Map Zoom Factor in Customizer
 */
function goodz_map_zoom_select() {

    for ( $i = 1; $i <= 21; $i++ ) {
        $results[$i] = $i;
    }

    return $results;

}

/**
 * Generate divider to use in Customizer page
 */
if ( class_exists( 'WP_Customize_Control' ) ) :

    class WP_Customize_Divider_Control extends WP_Customize_Control {
        public $type = 'divider';

        public function render_content() {
        ?>
            <div class="customizer-divider"></div>
        <?php
        }
    }

endif;

/**
 * Disable Visual Editor for Customizer
 */
if ( is_customize_preview() ) {
    add_filter( 'user_can_richedit' , '__return_false', 50 );
}


