<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 *
 * @themeskingdom
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

// Get product display type
$product_display_type = get_theme_mod( 'product_display_setting', 'standard-view' );
$product_qv_display   = get_theme_mod( 'product_display_qv', 1 );
$layout_display_type  = get_theme_mod( 'layout_type_setting', 'regular' );
$type_class           = '';
$product_link         = get_the_permalink();

if ( goodz_is_front_template() || 'standard-view' == $product_display_type && 'regular' == $layout_display_type ) :
	$type_class = 'quick-view-trigger';
endif;

?>
<div <?php wc_product_class( '', $product ); ?>>

	<?php do_action( 'woocommerce_before_shop_loop_item' ); ?>

			<figure>

				<?php
					/**
					 * Hook: woocommerce_before_shop_loop_item.
					 *
					 * @hooked woocommerce_show_product_loop_sale_flash - 10
					 * @hooked woocommerce_template_loop_product_thumbnail - 10
					 */
					do_action( 'woocommerce_before_shop_loop_item_title' );
				?>

				<?php if ( ( 'standard-view' == $product_display_type ) && $product_qv_display ) { ?>

					<span class="<?php echo esc_attr( $type_class ); ?>" data-pid="<?php echo get_the_ID(); ?>"><?php esc_html_e( 'Quick View', 'goodz' ); ?></span>

				<?php } ?>

			</figure>

		</a>

		<a href="<?php echo esc_attr( $product_link ); ?>" class="product-info verticalize-container">

			<div class="verticalize">

				<?php

					goodz_display_product_tags();

					/**
					 * Hook: woocommerce_shop_loop_item_title.
					 *
					 * @hooked woocommerce_template_loop_product_title - 10
					 */
					do_action( 'woocommerce_shop_loop_item_title' );

					/**
					 * Hook: woocommerce_after_shop_loop_item_title.
					 *
					 * @hooked woocommerce_template_loop_rating - 5
					 * @hooked woocommerce_template_loop_price - 10
					 */
					do_action( 'woocommerce_after_shop_loop_item_title' );
				?>
			</div>

		</a><!-- .product-info -->

	<?php

		/**
		 * Hook: woocommerce_after_shop_loop_item.
		 *
		 * @hooked woocommerce_template_loop_add_to_cart - 10
		 */
		//do_action( 'woocommerce_after_shop_loop_item' );

	?>

</div>
